<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Recovery;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\User\UserRecoveryTable;

final class UserRecoveryFinder extends AbstractFinder implements InterfaceUserRecoverySetter
{
    /**
     * setter interface
     */
    use TraitUserRecoverySetters;

    public function getTableName(): string
    {
        return UserRecoveryTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {UserRecoveryTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): UserRecoveryModel
    {
        return UserRecoveryModel::createFromUntouchedBean_noException(parent::pop());
    }
}
